/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.api.VWException;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseAssociationUI;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.resources.VWResource;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;

public class VWBaseTextAnnotationUI
extends JComponent
implements IVWSelectWorkflowItem {
    protected static final Dimension DEFAULT_SIZE = new Dimension(128, 64);
    protected static final int EDGE_MARGIN = 5;
    private FocusListener m_focusListeners = null;
    protected VWTextAnnotationDefinition m_textAnnotation = null;
    private boolean m_bHasFocus = false;
    private boolean m_bIsSelected = false;
    private Hashtable m_associations = null;
    protected VWStepRouteColors m_stepRouteColors = null;
    protected VWMapAttribs m_mapAttribs = null;

    public VWBaseTextAnnotationUI(VWTextAnnotationDefinition textAnnotation, VWStepRouteColors stepRouteColors, VWMapAttribs mapAttribs) {
        VWDebug.nullCheck(textAnnotation);
        this.m_textAnnotation = textAnnotation;
        this.m_stepRouteColors = stepRouteColors;
        this.m_mapAttribs = mapAttribs;
        this.init();
    }

    public VWTextAnnotationDefinition getDefinition() {
        return this.m_textAnnotation;
    }

    public Point getBoundaryPoint(double angle) {
        Point loc = this.getLocation();
        Point p = new Point();
        double tan = Math.tan(angle);
        int width = this.m_textAnnotation.getDimension().width;
        int height = this.m_textAnnotation.getDimension().height;
        double boundaryAngle = -1.0 / Math.tan((double)width / (double)height);
        if (angle <= boundaryAngle && angle >= -boundaryAngle) {
            p.y = (int)((double)loc.y + (double)height / 2.0 + (double)width / 2.0 * tan);
            p.x = loc.x + width;
        } else if (angle < boundaryAngle - Math.PI || angle > Math.PI - boundaryAngle) {
            p.y = (int)((double)loc.y + (double)height / 2.0 - (double)width / 2.0 * tan);
            p.x = loc.x - 1;
        } else if (angle > 0.0) {
            p.x = (int)((double)loc.x + (double)width / 2.0 + (double)height / (2.0 * tan));
            p.y = loc.y + height;
        } else {
            p.x = (int)((double)loc.x + (double)width / 2.0 - (double)height / (2.0 * tan));
            p.y = loc.y - 1;
        }
        return p;
    }

    public Rectangle getImageBounds() {
        return new Rectangle(this.getLocation(), this.m_textAnnotation.getDimension());
    }

    public void setLocation(Point loc) {
        try {
            if (this.m_textAnnotation != null) {
                this.m_textAnnotation.setLocation(loc);
            }
            super.setLocation(loc);
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    public Point getImageCenterLocation() {
        Point loc = this.getLocation();
        loc.x += this.m_textAnnotation.getDimension().width / 2;
        loc.y += this.m_textAnnotation.getDimension().height / 2;
        return loc;
    }

    public Point getImageBottomRightLoc() {
        Point loc = this.getLocation();
        loc.x += this.m_textAnnotation.getDimension().width;
        loc.y += this.m_textAnnotation.getDimension().height;
        return loc;
    }

    public synchronized void addFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.add(this.m_focusListeners, l);
    }

    public synchronized void removeFocusListener(FocusListener l) {
        this.m_focusListeners = AWTEventMulticaster.remove(this.m_focusListeners, l);
    }

    public boolean getFocus() {
        return this.m_bHasFocus;
    }

    public void setFocus(boolean bFocus) {
        if (this.m_bHasFocus != bFocus) {
            this.m_bHasFocus = bFocus;
            if (this.m_bHasFocus) {
                this.setSelect(true);
            }
            if (this.m_focusListeners != null) {
                if (this.m_bHasFocus) {
                    this.m_focusListeners.focusGained(new FocusEvent(this, 1004));
                } else {
                    this.m_focusListeners.focusLost(new FocusEvent(this, 1005));
                }
            }
        }
    }

    public boolean getSelect() {
        return this.m_bIsSelected;
    }

    public void setSelect(boolean bSelect) {
        if (this.m_bIsSelected != bSelect) {
            this.m_bIsSelected = bSelect;
            if (!bSelect) {
                this.setFocus(false);
            }
        }
    }

    public boolean contains(Point loc) {
        return loc.x >= this.getX() && loc.x <= this.getX() + this.m_textAnnotation.getDimension().width && loc.y >= this.getY() && loc.y <= this.getY() + this.m_textAnnotation.getDimension().height;
    }

    public boolean captureFocus(Point loc) {
        boolean bResult = false;
        if (this.contains(loc)) {
            this.setFocus(true);
            bResult = true;
        }
        return bResult;
    }

    public void dragTo(Point loc) {
        this.setLocation(loc);
        Enumeration e = this.getAssociations();
        while (e.hasMoreElements()) {
            VWBaseAssociationUI association = (VWBaseAssociationUI)e.nextElement();
            association.recalcPosition();
        }
    }

    public boolean isPointNearEdge(Point pt) {
        Rectangle rightRect;
        Rectangle leftRect = rightRect = new Rectangle();
        Rectangle bottomRect = rightRect;
        Rectangle topRect = rightRect;
        topRect.x = this.getX();
        topRect.y = this.getY() - 5;
        topRect.width = this.m_textAnnotation.getDimension().width;
        topRect.height = 10;
        if (topRect.contains(pt)) {
            return true;
        }
        rightRect.x = this.getX() + this.m_textAnnotation.getDimension().width - 5;
        rightRect.y = this.getY();
        rightRect.width = 10;
        rightRect.height = this.m_textAnnotation.getDimension().height;
        if (rightRect.contains(pt)) {
            return true;
        }
        bottomRect.x = this.getX();
        bottomRect.y = this.getY() + this.m_textAnnotation.getDimension().height - 5;
        bottomRect.width = this.m_textAnnotation.getDimension().width;
        bottomRect.height = 10;
        if (bottomRect.contains(pt)) {
            return true;
        }
        leftRect.x = this.getX() - 5;
        leftRect.y = this.getY();
        leftRect.width = 10;
        leftRect.height = this.m_textAnnotation.getDimension().height;
        return leftRect.contains(pt);
    }

    public Enumeration getAssociations() {
        if (this.m_associations == null) {
            this.m_associations = new Hashtable();
        }
        return this.m_associations.keys();
    }

    public void addAssociation(VWBaseAssociationUI association, Object targetUI) {
        if (this.m_associations == null) {
            this.m_associations = new Hashtable();
        }
        if (!this.m_associations.containsKey(association)) {
            this.m_associations.put(association, targetUI);
        } else {
            VWDebug.logError("The association is already in the collection!");
        }
    }

    public void removeAssociation(VWBaseAssociationUI association) {
        if (this.m_associations.remove(association) == null) {
            VWDebug.logError("The association is not in the collection!");
        }
    }

    public boolean hasAnAnnotationToItem(Object targetItem) {
        boolean bFound = false;
        Enumeration e = this.getAssociations();
        while (e.hasMoreElements()) {
            VWBaseAssociationUI association = (VWBaseAssociationUI)e.nextElement();
            if (!association.hasReferenceToItem(targetItem)) continue;
            bFound = true;
        }
        return bFound;
    }

    public Rectangle getBounds() {
        return this.getImageBounds();
    }

    public boolean hasFocus() {
        return this.m_bHasFocus;
    }

    public boolean isSelected() {
        return this.m_bIsSelected;
    }

    public void removeReferences() {
        this.m_focusListeners = null;
        this.m_textAnnotation = null;
        if (this.m_associations != null) {
            this.m_associations.clear();
            this.m_associations = null;
        }
    }

    public void paintComponent(Graphics g) {
        if (this.m_mapAttribs.isTextAnnotationsVisible()) {
            Color oldColor = g.getColor();
            int nBorderWidth = 1;
            if (this.m_bHasFocus) {
                g.setColor(this.m_stepRouteColors.getFocusColor());
                nBorderWidth = 2;
            } else if (this.m_bIsSelected) {
                g.setColor(this.m_stepRouteColors.getSelectionColor());
                nBorderWidth = 2;
            } else {
                g.setColor(this.m_stepRouteColors.getDefaultColor());
            }
            Rectangle rect = this.getImageBounds();
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            rect.grow(-nBorderWidth, -nBorderWidth);
            g.setColor(this.m_textAnnotation.getBgColor());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g.setColor(oldColor);
            this.renderMessage(g, rect.x, rect.y);
        }
    }

    public void printComponent(Graphics2D g, PageFormat pf, int pi, int wp, int hp) throws PrinterException {
        if (this.m_mapAttribs.isTextAnnotationsVisible()) {
            int row = pi / wp;
            int col = pi % wp;
            double iW = pf.getImageableWidth();
            double iH = pf.getImageableHeight();
            int pageX = (int)Math.round((double)col * iW);
            int pageY = (int)Math.round((double)row * iH);
            int pageX2 = pageX + (int)iW;
            int pageY2 = pageY + (int)iH;
            int imageXul = this.getX();
            int imageYul = this.getY();
            int imageXlr = imageXul + this.m_textAnnotation.getDimension().width;
            int imageYlr = imageYul + this.m_textAnnotation.getDimension().height;
            if (imageXul >= pageX && imageXul <= pageX2 && imageYul >= pageY && imageYul <= pageY2 || imageXlr >= pageX && imageXlr <= pageX2 && imageYlr >= pageY && imageYlr <= pageY2) {
                Color oldColor = g.getColor();
                g.setColor(this.m_stepRouteColors.getDefaultColor());
                Rectangle rect = this.getImageBounds();
                rect.x = imageXul - pageX;
                rect.y = imageYul - pageY;
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(this.m_textAnnotation.getBgColor());
                rect.grow(-1, -1);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(oldColor);
                this.renderMessage(g, rect.x, rect.y);
            }
        }
    }

    protected void init() {
        try {
            if (this.m_textAnnotation.getLocation() == null) {
                this.setLocation(new Point(50, 50));
            } else {
                this.setLocation(this.m_textAnnotation.getLocation());
            }
            if (this.m_textAnnotation.getDimension() == null) {
                this.m_textAnnotation.setDimension(DEFAULT_SIZE);
            }
            if (this.m_textAnnotation.getBgColor() == null) {
                this.m_textAnnotation.setBgColor(this.m_mapAttribs.getTextAnnotationDefaultBgColor());
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
    }

    protected void renderMessage(Graphics g, int xLoc, int yLoc) {
        block14: {
            try {
                boolean bRemainingRows;
                int nRowIndex;
                String[] rows;
                int nRows;
                int nHorizChars;
                FontMetrics fontMetrics;
                Rectangle rect;
                block15: {
                    int nIndex;
                    String message;
                    if (this.m_textAnnotation == null || (message = this.m_textAnnotation.getMessage()) == null || message.length() <= 0) break block14;
                    rect = this.getImageBounds();
                    rect.x = xLoc;
                    rect.y = yLoc;
                    fontMetrics = g.getFontMetrics();
                    rect.grow(-(fontMetrics.getDescent() * 2), -fontMetrics.getDescent());
                    long avgWidth = 0L;
                    int[] widthArray = fontMetrics.getWidths();
                    for (int nIndex2 = 0; nIndex2 < widthArray.length; ++nIndex2) {
                        avgWidth += (long)widthArray[nIndex2];
                    }
                    nHorizChars = rect.width / (int)(avgWidth / (long)widthArray.length);
                    nRows = rect.height / fontMetrics.getHeight();
                    rows = new String[nRows];
                    nRowIndex = 0;
                    bRemainingRows = false;
                    while ((nIndex = message.indexOf("\n")) != -1) {
                        rows[nRowIndex] = message.substring(0, nIndex);
                        message = message.substring(nIndex + 1, message.length());
                        if (++nRowIndex < nRows) continue;
                        bRemainingRows = true;
                        break block15;
                    }
                    rows[nRowIndex] = message;
                }
                int nYpos = rect.y + fontMetrics.getMaxAscent();
                int nYOffset = (rect.height - fontMetrics.getAscent()) / nRows;
                nRowIndex = 0;
                String rowString = rows[nRowIndex];
                for (int nRow = 0; nRow < nRows && rowString != null; ++nRow) {
                    if (fontMetrics.stringWidth(rowString) < rect.width) {
                        if (bRemainingRows && nRow == nRows - 1 && rowString != null) {
                            rowString = this.addEllipsesToString(rowString, fontMetrics, rect.width);
                        }
                        g.drawString(rowString.trim(), rect.x, nYpos);
                        if (++nRowIndex >= nRows) break;
                        rowString = rows[nRowIndex];
                    } else {
                        int nIndex;
                        String tmpString;
                        int nChars = nHorizChars;
                        boolean bSmaller = false;
                        boolean bLarger = false;
                        while (true) {
                            if (rowString.length() < nChars) {
                                nChars = rowString.length();
                                if (bLarger) break;
                            }
                            if (fontMetrics.stringWidth(tmpString = rowString.substring(0, nChars)) < rect.width) {
                                if (!bSmaller) {
                                    ++nChars;
                                    bLarger = true;
                                    continue;
                                }
                                break;
                            }
                            --nChars;
                            bSmaller = true;
                            if (bLarger) break;
                        }
                        if ((nIndex = (tmpString = rowString.substring(0, nChars)).lastIndexOf(" ")) != -1) {
                            nChars = nIndex;
                        }
                        tmpString = rowString.substring(0, nChars);
                        if (nRow == nRows - 1 && tmpString != null && tmpString.length() > 0) {
                            tmpString = this.addEllipsesToString(tmpString, fontMetrics, rect.width);
                        }
                        g.drawString(tmpString.trim(), rect.x, nYpos);
                        rowString = rowString.substring(nChars);
                    }
                    nYpos += nYOffset;
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    private String addEllipsesToString(String rowString, FontMetrics fontMetrics, int nWidth) {
        String tmpString;
        int nChars = rowString.length();
        while (fontMetrics.stringWidth(tmpString = rowString.substring(0, nChars) + VWResource.s_dots) >= nWidth) {
            --nChars;
        }
        return rowString.substring(0, nChars).trim() + VWResource.s_dots;
    }
}

